#ifndef __NeptuneScene_H__
#define __NeptuneScene_H__

#include "NeptuneCommon.h"
//#include "NeptuneHost.h"

NEPLIB_NS_START

class CNeptuneHost;
//class CMglLayer;

//	NX錾
class NEPDLL_EXP CNeptuneScene
{
private:
	CNeptuneHost* m_pHost;
	//CMglLayer* m_pMglLayer;
	void* m_pInternal;

protected:
	void LoadImageToPool(const char* szImageFilePath, const char* szImageName);
	void AddLayer(const char* szImageName, int depth,
		float x=0.0f, float y=0.0f, bool bShow=true, NEPTUNE_COLOR color=NEPCOLOR_WHITE, 
		float fScaleX=1.0f, float fScaleY=1.0f, float fAngle=0.0f);

public:
	//	RXgN^EfXgN^
	CNeptuneScene();
	virtual ~CNeptuneScene();

	bool Start(CNeptuneHost *pHost);
	
	//	[U郁\bh
	virtual bool UserInitializeLogic()=0;
	virtual bool UserFinalizeLogic()=0;
	virtual bool UserOneFrameLogic()=0;

	virtual bool OnKeyEventHandler(BYTE onKeyArray[]);
};

NEPLIB_NS_END

#endif//__NeptuneScene_H__
